﻿/**
 * Toggles the visibility of the error details section whenever the show/hide hyperlink is clicked on.
 * @param {Object} linkDomElement - The DOM element corresponding to the show/hide details hyperlink.
 * @param {string} divElementId - The ID of the element corresponding to the section
 * that displays additional details about errors.
 */
function toggleErrorDetails(linkDomElement, divElementId) {
    var divElement = $('#' + divElementId);
    var linkElement = $(linkDomElement);

    if (linkElement.text() === 'Show details') {
        divElement.show();
        linkElement.text('Hide details');
    } else {
        divElement.hide();
        linkElement.text('Show details');
    }
}
